/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json.token;

import de.ecconia.java.json.JSONException;
import de.ecconia.java.json.token.JSONToken;
import java.util.List;

public class JSONTokenIterator {
    private final List<JSONToken> list;
    private int pointer = 0;
    private String debug = "Debug: ";
    private final boolean debugEnabled;

    public JSONTokenIterator(List<JSONToken> list, boolean debugEnabled) {
        this.list = list;
        this.debugEnabled = debugEnabled;
        this.debug = debugEnabled ? "Debug: " : "";
    }

    public boolean isEnd() {
        return this.list.size() == this.pointer;
    }

    public JSONToken next() {
        try {
            JSONToken t = this.list.get(this.pointer++);
            if (this.debugEnabled) {
                this.debug = String.valueOf(this.debug) + (Object)((Object)t.getType()) + (t.getContent() != null ? "<" + t.getContent() + ">" : "") + " ";
            }
            return t;
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONException("Unexpected end of JSON.");
        }
    }

    public String history() {
        return this.debug;
    }

    public void undo() {
        if (this.debugEnabled) {
            this.debug = String.valueOf(this.debug) + "undo";
        }
        --this.pointer;
    }
}

