/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json;

import de.ecconia.java.json.JSONNode;
import java.util.ArrayList;
import java.util.List;

public class JSONArray
extends JSONNode {
    private final List<Object> entries = new ArrayList<Object>();

    public void add(Object obj) {
        this.entries.add(obj);
    }

    public List<Object> getEntries() {
        return this.entries;
    }

    @Override
    public String printJSON() {
        String tmp = "";
        if (!this.entries.isEmpty()) {
            tmp = String.valueOf(tmp) + JSONArray.printJSON(this.entries.get(0));
            int i = 1;
            while (i < this.entries.size()) {
                tmp = String.valueOf(tmp) + ',' + JSONArray.printJSON(this.entries.get(i));
                ++i;
            }
        }
        return String.valueOf('[') + tmp + ']';
    }

    @Override
    public void debugTree(String prefix) {
        System.out.println('[');
        String innerPrefix = String.valueOf(prefix) + "\u00b7   ";
        for (Object obj : this.entries) {
            System.out.print(innerPrefix);
            if (obj == null) {
                System.out.println("null");
                continue;
            }
            if (obj instanceof Boolean) {
                System.out.println(obj);
                continue;
            }
            if (obj instanceof Number) {
                System.out.println(obj);
                continue;
            }
            if (obj instanceof String) {
                System.out.println("\"" + ((String)obj).replace("\n", "\\n") + "\"");
                continue;
            }
            JSONNode node = (JSONNode)obj;
            node.debugTree(innerPrefix);
        }
        System.out.println(String.valueOf(prefix) + "]");
    }
}

