/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json;

import de.ecconia.java.json.JSONArray;
import de.ecconia.java.json.JSONException;
import de.ecconia.java.json.JSONNode;
import de.ecconia.java.json.JSONObject;
import de.ecconia.java.json.token.JSONToken;
import de.ecconia.java.json.token.JSONTokenIterator;
import de.ecconia.java.json.token.JSONType;
import java.math.BigDecimal;

public class JSONParser {
    public static JSONNode parse(String s) {
        return JSONParser.parse(s, false);
    }

    public static JSONNode parse(String s, boolean debug) {
        JSONTokenIterator i = JSONToken.parse(s, debug);
        JSONType type = i.next().getType();
        if (type == JSONType.OBJECT_OPEN) {
            return JSONParser.parseObject(i, Scope.INNER);
        }
        if (type == JSONType.ARRAY_OPEN) {
            return JSONParser.parseArray(i, Scope.INNER);
        }
        throw new JSONException("Parsed JSON either has to be an Object or an Array.");
    }

    private static JSONObject parseObject(JSONTokenIterator i, Scope scope) {
        JSONObject ret;
        block16: {
            ret = new JSONObject();
            String key = null;
            while (true) {
                JSONToken currentToken = i.next();
                if (scope == Scope.OUTTER) {
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() == JSONType.OBJECT_OPEN) {
                        scope = Scope.INNER;
                        continue;
                    }
                    throw new JSONException("Unexpected token. " + i.history());
                }
                if (scope == Scope.INNER) {
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() != JSONType.OBJECT_CLOSE) {
                        if (currentToken.getType() == JSONType.QUOTE) {
                            key = JSONParser.parseString(i, Scope.INNER);
                            scope = Scope.DOUBLES;
                            continue;
                        }
                        throw new JSONException("Unexpected token. " + i.history());
                    }
                    break block16;
                }
                if (scope == Scope.DOUBLES) {
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() == JSONType.PAIR_SEPARATOR) {
                        scope = Scope.EXPECT_VALUE;
                        continue;
                    }
                    throw new JSONException("Unexpected token. " + i.history());
                }
                if (scope == Scope.EXPECT_VALUE) {
                    Object obj;
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() == JSONType.ARRAY_OPEN) {
                        JSONArray arr = JSONParser.parseArray(i, Scope.INNER);
                        ret.put(key, arr);
                        scope = Scope.NEXT_INNER;
                        continue;
                    }
                    if (currentToken.getType() == JSONType.OBJECT_OPEN) {
                        obj = JSONParser.parseObject(i, Scope.INNER);
                        ret.put(key, obj);
                        scope = Scope.NEXT_INNER;
                        continue;
                    }
                    if (currentToken.getType() == JSONType.QUOTE) {
                        String string = JSONParser.parseString(i, Scope.INNER);
                        ret.put(key, string);
                        scope = Scope.NEXT_INNER;
                        continue;
                    }
                    if (currentToken.getType() == JSONType.UNKNOWN) {
                        obj = JSONParser.parseUnknown(i, currentToken.getContent().charValue());
                        ret.put(key, obj);
                        scope = Scope.NEXT_INNER;
                        continue;
                    }
                    throw new JSONException("Unexpected token. " + i.history());
                }
                if (scope == Scope.NEXT_INNER) {
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() == JSONType.SEPARATOR) {
                        scope = Scope.EXPECT_ENTRY;
                        continue;
                    }
                    if (currentToken.getType() != JSONType.OBJECT_CLOSE) {
                        throw new JSONException("Unexpected token. " + i.history());
                    }
                    break block16;
                }
                if (scope != Scope.EXPECT_ENTRY || currentToken.getType() == JSONType.SPACE) continue;
                if (currentToken.getType() != JSONType.QUOTE) break;
                key = JSONParser.parseString(i, Scope.INNER);
                scope = Scope.DOUBLES;
            }
            throw new JSONException("Unexpected token. " + i.history());
        }
        return ret;
    }

    private static String parseString(JSONTokenIterator i, Scope scope) {
        JSONToken currentToken;
        String value = "";
        while (true) {
            currentToken = i.next();
            if (scope == Scope.OUTTER) {
                if (currentToken.getType() == JSONType.SPACE) continue;
                if (currentToken.getType() == JSONType.QUOTE) {
                    scope = Scope.INNER;
                    continue;
                }
                throw new JSONException("Unexpected token. " + i.history());
            }
            if (scope != Scope.INNER) continue;
            if (currentToken.getType() != JSONType.TEXT) break;
            value = String.valueOf(value) + currentToken.getContent();
        }
        if (currentToken.getType() != JSONType.QUOTE) {
            throw new JSONException("Unexpected token. " + i.history());
        }
        return value;
    }

    private static Object parseUnknown(JSONTokenIterator i, char firstChar) {
        String value;
        block8: {
            JSONToken currentToken;
            value = String.valueOf(firstChar);
            while (true) {
                if ((currentToken = i.next()).getType() == JSONType.SPACE || currentToken.getType() == JSONType.SEPARATOR) {
                    i.undo();
                    break block8;
                }
                if (currentToken.getType() != JSONType.UNKNOWN) break;
                value = String.valueOf(value) + currentToken.getContent();
            }
            if (currentToken.getType() == JSONType.ARRAY_CLOSE || currentToken.getType() == JSONType.OBJECT_CLOSE) {
                i.undo();
            } else {
                throw new JSONException("Unexpected token. " + i.history());
            }
        }
        if (value.equals("null")) {
            return null;
        }
        if (value.equals("true")) {
            return new Boolean(true);
        }
        if (value.equals("false")) {
            return new Boolean(false);
        }
        if (value.matches("-?(0|[1-9][0-9]*)(.[0-9]+)?([eE][\\-+]?[0-9]+)?")) {
            return new BigDecimal(value);
        }
        throw new JSONException("Value does not match a valid format: >" + value + "< " + i.history());
    }

    private static JSONArray parseArray(JSONTokenIterator i, Scope scope) {
        JSONArray ret;
        block15: {
            ret = new JSONArray();
            while (true) {
                String string;
                Object obj;
                JSONArray arr;
                JSONToken currentToken = i.next();
                if (scope == Scope.OUTTER) {
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() == JSONType.ARRAY_OPEN) {
                        scope = Scope.INNER;
                        continue;
                    }
                    throw new JSONException("Unexpected token. " + i.history());
                }
                if (scope == Scope.INNER) {
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() != JSONType.ARRAY_CLOSE) {
                        if (currentToken.getType() == JSONType.ARRAY_OPEN) {
                            arr = JSONParser.parseArray(i, Scope.INNER);
                            ret.add(arr);
                            scope = Scope.NEXT_INNER;
                            continue;
                        }
                        if (currentToken.getType() == JSONType.OBJECT_OPEN) {
                            obj = JSONParser.parseObject(i, Scope.INNER);
                            ret.add(obj);
                            scope = Scope.NEXT_INNER;
                            continue;
                        }
                        if (currentToken.getType() == JSONType.QUOTE) {
                            string = JSONParser.parseString(i, Scope.INNER);
                            ret.add(string);
                            scope = Scope.NEXT_INNER;
                            continue;
                        }
                        if (currentToken.getType() == JSONType.UNKNOWN) {
                            obj = JSONParser.parseUnknown(i, currentToken.getContent().charValue());
                            ret.add(obj);
                            scope = Scope.NEXT_INNER;
                            continue;
                        }
                        throw new JSONException("Unexpected token. " + i.history());
                    }
                    break block15;
                }
                if (scope == Scope.NEXT_INNER) {
                    if (currentToken.getType() == JSONType.SPACE) continue;
                    if (currentToken.getType() == JSONType.SEPARATOR) {
                        scope = Scope.EXPECT_ENTRY;
                        continue;
                    }
                    if (currentToken.getType() != JSONType.ARRAY_CLOSE) {
                        throw new JSONException("Unexpected token. " + i.history());
                    }
                    break block15;
                }
                if (scope != Scope.EXPECT_ENTRY || currentToken.getType() == JSONType.SPACE) continue;
                if (currentToken.getType() == JSONType.ARRAY_OPEN) {
                    arr = JSONParser.parseArray(i, Scope.INNER);
                    ret.add(arr);
                    scope = Scope.NEXT_INNER;
                    continue;
                }
                if (currentToken.getType() == JSONType.OBJECT_OPEN) {
                    obj = JSONParser.parseObject(i, Scope.INNER);
                    ret.add(obj);
                    scope = Scope.NEXT_INNER;
                    continue;
                }
                if (currentToken.getType() == JSONType.QUOTE) {
                    string = JSONParser.parseString(i, Scope.INNER);
                    ret.add(string);
                    scope = Scope.NEXT_INNER;
                    continue;
                }
                if (currentToken.getType() != JSONType.UNKNOWN) break;
                obj = JSONParser.parseUnknown(i, currentToken.getContent().charValue());
                ret.add(obj);
                scope = Scope.NEXT_INNER;
            }
            throw new JSONException("Unexpected token. " + i.history());
        }
        return ret;
    }

    static enum Scope {
        OUTTER,
        INNER,
        READING_KEY,
        DOUBLES,
        EXPECT_VALUE,
        NEXT_INNER,
        EXPECT_ENTRY;

    }
}

