/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json.token;

import de.ecconia.java.json.token.JSONTokenIterator;
import de.ecconia.java.json.token.JSONType;
import java.util.ArrayList;

public class JSONToken {
    private final JSONType type;
    private Character content;

    private JSONToken(JSONType type, char content) {
        this.type = type;
        this.content = Character.valueOf(content);
    }

    private JSONToken(JSONType type) {
        this.type = type;
    }

    public Character getContent() {
        return this.content;
    }

    public JSONType getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.type.name()) + (this.content != null ? "<" + this.content + ">" : "");
    }

    public static JSONTokenIterator parse(String s, boolean debug) {
        ArrayList<JSONToken> tokens = new ArrayList<JSONToken>();
        boolean inQuote = false;
        boolean nextEscapted = false;
        boolean thisEscaped = false;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (inQuote) {
                thisEscaped = false;
                if (nextEscapted) {
                    thisEscaped = true;
                    nextEscapted = false;
                } else if (c == '\\') {
                    nextEscapted = true;
                }
                if (!thisEscaped && c == '\"') {
                    tokens.add(new JSONToken(JSONType.QUOTE));
                    inQuote = false;
                } else {
                    tokens.add(new JSONToken(JSONType.TEXT, c));
                }
            } else {
                switch (c) {
                    case ':': {
                        tokens.add(new JSONToken(JSONType.PAIR_SEPARATOR));
                        break;
                    }
                    case '{': {
                        tokens.add(new JSONToken(JSONType.OBJECT_OPEN));
                        break;
                    }
                    case '}': {
                        tokens.add(new JSONToken(JSONType.OBJECT_CLOSE));
                        break;
                    }
                    case '[': {
                        tokens.add(new JSONToken(JSONType.ARRAY_OPEN));
                        break;
                    }
                    case ']': {
                        tokens.add(new JSONToken(JSONType.ARRAY_CLOSE));
                        break;
                    }
                    case ',': {
                        tokens.add(new JSONToken(JSONType.SEPARATOR));
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        tokens.add(new JSONToken(JSONType.SPACE, c));
                        break;
                    }
                    case '\"': {
                        inQuote = true;
                        tokens.add(new JSONToken(JSONType.QUOTE));
                        break;
                    }
                    default: {
                        tokens.add(new JSONToken(JSONType.UNKNOWN, c));
                    }
                }
            }
            ++n2;
        }
        return new JSONTokenIterator(tokens, debug);
    }
}

