package de.ecconia.java.pnet.encryption;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import de.ecconia.java.pnet.exceptions.CipherException;

public class SyncCryptUnit
{
	private final Cipher decryptCipher;
	private final Cipher encryptCipher;
	
	public SyncCryptUnit(SecretKey key)
	{
		try
		{
			decryptCipher = Cipher.getInstance("AES/CFB8/NoPadding");
			decryptCipher.init(Cipher.DECRYPT_MODE, key, new IvParameterSpec(key.getEncoded()));
			encryptCipher = Cipher.getInstance("AES/CFB8/NoPadding");
			encryptCipher.init(Cipher.ENCRYPT_MODE, key, new IvParameterSpec(key.getEncoded()));
		}
		catch(InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException | InvalidAlgorithmParameterException e)
		{
			throw new CipherException(e);
		}
	}
	
	public byte decryptByte(byte b)
	{
		return decryptBytes(new byte[] {b})[0];
	}
	
	public byte[] decryptBytes(byte[] bytes)
	{
		byte o[] = new byte[decryptCipher.getOutputSize(bytes.length)];
		
		try
		{
			decryptCipher.update(bytes, 0, bytes.length, o, 0);
			return o;
		}
		catch(ShortBufferException e)
		{
			//Should practically never happen in this usecase.
			throw new RuntimeException(e);
		}
	}
	
	public byte[] encryptBytes(byte[] bytes)
	{
		byte o[] = new byte[encryptCipher.getOutputSize(bytes.length)];
		
		try
		{
			encryptCipher.update(bytes, 0, bytes.length, o, 0);
			return o;
		}
		catch(ShortBufferException e)
		{
			//Should practically never happen in this usecase.
			throw new RuntimeException(e);
		}
	}
	
	//Static key generation:
	
	public static SecretKey secredKeyFromBytes(byte[] bytes)
	{
		return new SecretKeySpec(bytes, "AES");
	}
	
	public static SecretKey generateKey(int bits)
	{
		KeyGenerator gen;
		try
		{
			gen = KeyGenerator.getInstance("AES");
			gen.init(bits);
			return gen.generateKey();
		}
		catch(NoSuchAlgorithmException e)
		{
			throw new CipherException(e);
		}
	}
}
