/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.pnet.connector;

import de.ecconia.java.pnet.exceptions.CloseException;
import de.ecconia.java.pnet.exceptions.ServerException;
import de.ecconia.java.pnet.exceptions.StartException;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.locks.ReentrantLock;

public class GenericServer {
    private static int serverID = 0;
    private final int port;
    private SocketHandler socketHandler;
    private ServerRuntimeException exceptionHandler;
    private Thread serverThread;
    private ServerSocket server;
    private ReentrantLock ssLock = new ReentrantLock();

    public GenericServer(int port) {
        this.port = port;
    }

    public void setSocketHandler(SocketHandler socketHandler) {
        this.ssLock.lock();
        if (this.serverThread != null) {
            this.ssLock.unlock();
            throw new IllegalStateException("Cannot change the SocketHandler, while the server is running.");
        }
        this.socketHandler = socketHandler;
        this.ssLock.unlock();
    }

    public void setServerRuntimeExceptionHandler(ServerRuntimeException exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void start() {
        this.ssLock.lock();
        if (this.socketHandler == null) {
            this.ssLock.unlock();
            throw new IllegalStateException("Connection processor has not been set yet.");
        }
        if (this.serverThread != null) {
            this.ssLock.unlock();
            throw new IllegalStateException("Server is already running.");
        }
        try {
            this.server = new ServerSocket(this.port);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                if (e.getMessage().equals("Permission denied (Bind failed)")) {
                    this.ssLock.unlock();
                    throw new StartException("Cannot bind server on this port: No permission.");
                }
                if (e.getMessage().equals("Address already in use (Bind failed)")) {
                    this.ssLock.unlock();
                    throw new StartException("Cannot bind server on this port: Port in use.");
                }
            }
            this.ssLock.unlock();
            throw new StartException.UnexpectedStartException(e);
        }
        this.serverThread = new Thread(() -> {
            try {
                try {
                    while (true) {
                        Socket socket = this.server.accept();
                        new Thread(() -> {
                            block2: {
                                try {
                                    this.socketHandler.newSocket(socket);
                                }
                                catch (Exception e) {
                                    if (this.exceptionHandler == null) break block2;
                                    this.exceptionHandler.newException(new ServerException.ClientCreationException(e));
                                }
                            }
                        }).start();
                    }
                }
                catch (SocketException e) {
                    if ("Socket closed".equals(e.getMessage())) {
                        return;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.newException(new ServerException.ServerCrashException(e));
                }
                return;
            }
        }, "ServerThread#" + ++serverID);
        this.serverThread.start();
        this.ssLock.unlock();
    }

    public void stop() throws CloseException {
        this.ssLock.lock();
        if (this.serverThread == null) {
            this.ssLock.unlock();
            throw new IllegalStateException("Server is not running.");
        }
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException e) {
            throw new CloseException(e);
        }
        try {
            this.serverThread.join();
            this.serverThread = null;
        }
        catch (InterruptedException e) {
            throw new CloseException.CloseInterruptedException();
        }
        this.ssLock.unlock();
    }

    public boolean isRunning() {
        return this.serverThread != null;
    }

    public int getPort() {
        return this.port;
    }

    public static interface ServerRuntimeException {
        public void newException(ServerException var1);
    }

    public static interface SocketHandler {
        public void newSocket(Socket var1);
    }
}

